export interface User {
  id: string;
  email: string;
  full_name: string;
  role: 'admin' | 'cashier';
  created_at: string;
  updated_at: string;
}

export interface Category {
  id: string;
  name: string;
  description?: string;
  created_at: string;
}

export interface Service {
  id: string;
  name: string;
  description?: string;
  unit_price: number;
  category_id?: string;
  category?: Category;
  is_active: boolean;
  created_at: string;
  updated_at: string;
}

export interface SaleItem {
  id: string;
  sale_id: string;
  service_id: string;
  service?: Service;
  quantity: number;
  unit_price: number;
  total_price: number;
}

export interface Sale {
  id: string;
  receipt_number: string;
  customer_name?: string;
  subtotal: number;
  tax_amount: number;
  discount_amount: number;
  total_amount: number;
  payment_method: 'cash' | 'mpesa' | 'card';
  payment_reference?: string;
  cashier_id: string;
  cashier?: User;
  sale_items?: SaleItem[];
  created_at: string;
}

export interface ShopSettings {
  id: string;
  shop_name: string;
  address: string;
  phone_number: string;
  email?: string;
  mpesa_till_number?: string;
  tax_rate: number;
  receipt_header?: string;
  receipt_footer?: string;
  logo_url?: string;
  updated_at: string;
}

export interface CartItem {
  service: Service;
  quantity: number;
}

export interface DashboardStats {
  todaySales: number;
  todayTransactions: number;
  topServices: Array<{
    service_name: string;
    total_sales: number;
    transaction_count: number;
  }>;
  cashierPerformance: Array<{
    cashier_name: string;
    total_sales: number;
    transaction_count: number;
  }>;
}