<?php
require_once '../config/config.php';
require_once '../config/database.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

$auth->requireLogin();

$saleId = intval($_GET['sale_id'] ?? 0);

if (!$saleId) {
    sendJsonResponse(['success' => false, 'message' => 'Sale ID required'], 400);
}

try {
    // Get sale details
    $stmt = $db->prepare("
        SELECT s.*, u.full_name as cashier_name
        FROM sales s
        JOIN users u ON s.cashier_id = u.id
        WHERE s.id = ?
    ");
    $stmt->execute([$saleId]);
    $sale = $stmt->fetch();

    if (!$sale) {
        sendJsonResponse(['success' => false, 'message' => 'Sale not found'], 404);
    }

    // Check permissions - cashiers can only view their own sales
    if (!$auth->isAdmin() && $sale['cashier_id'] != $_SESSION['user_id']) {
        sendJsonResponse(['success' => false, 'message' => 'Access denied'], 403);
    }

    // Get sale items
    $stmt = $db->prepare("
        SELECT si.*, srv.name as service_name
        FROM sale_items si
        JOIN services srv ON si.service_id = srv.id
        WHERE si.sale_id = ?
        ORDER BY srv.name
    ");
    $stmt->execute([$saleId]);
    $saleItems = $stmt->fetchAll();

    $sale['items'] = $saleItems;

    sendJsonResponse(['success' => true, 'data' => $sale]);

} catch (Exception $e) {
    logError("Error fetching transaction details: " . $e->getMessage());
    sendJsonResponse(['success' => false, 'message' => 'Internal server error'], 500);
}
?>