<?php
require_once '../config/config.php';
require_once '../config/database.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

$auth->requireLogin();

$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? $_POST['action'] ?? '';

try {
    switch ($method) {
        case 'GET':
            if ($action === 'list') {
                $stmt = $db->prepare("
                    SELECT s.*, c.name as category_name 
                    FROM services s 
                    LEFT JOIN categories c ON s.category_id = c.id 
                    ORDER BY s.name
                ");
                $stmt->execute();
                $services = $stmt->fetchAll();
                sendJsonResponse(['success' => true, 'data' => $services]);
            } elseif ($action === 'categories') {
                $stmt = $db->prepare("SELECT * FROM categories ORDER BY name");
                $stmt->execute();
                $categories = $stmt->fetchAll();
                sendJsonResponse(['success' => true, 'data' => $categories]);
            } else {
                sendJsonResponse(['success' => false, 'message' => 'Invalid action'], 400);
            }
            break;

        case 'POST':
            $auth->requireAdmin();
            
            if (!$auth->validateCSRFToken($_POST['csrf_token'] ?? '')) {
                sendJsonResponse(['success' => false, 'message' => 'CSRF token validation failed'], 403);
            }

            if ($action === 'create') {
                $name = sanitizeInput($_POST['name'] ?? '');
                $description = sanitizeInput($_POST['description'] ?? '');
                $unitPrice = floatval($_POST['unit_price'] ?? 0);
                $categoryId = intval($_POST['category_id']) ?: null;
                $isActive = isset($_POST['is_active']) ? 1 : 0;

                if (empty($name) || $unitPrice <= 0) {
                    sendJsonResponse(['success' => false, 'message' => 'Name and valid price required'], 400);
                }

                $stmt = $db->prepare("
                    INSERT INTO services (name, description, unit_price, category_id, is_active)
                    VALUES (?, ?, ?, ?, ?)
                ");
                $stmt->execute([$name, $description, $unitPrice, $categoryId, $isActive]);
                
                sendJsonResponse(['success' => true, 'message' => 'Service created successfully']);

            } elseif ($action === 'update') {
                $serviceId = intval($_POST['service_id'] ?? 0);
                $name = sanitizeInput($_POST['name'] ?? '');
                $description = sanitizeInput($_POST['description'] ?? '');
                $unitPrice = floatval($_POST['unit_price'] ?? 0);
                $categoryId = intval($_POST['category_id']) ?: null;
                $isActive = isset($_POST['is_active']) ? 1 : 0;

                if (!$serviceId || empty($name) || $unitPrice <= 0) {
                    sendJsonResponse(['success' => false, 'message' => 'Invalid data provided'], 400);
                }

                $stmt = $db->prepare("
                    UPDATE services 
                    SET name = ?, description = ?, unit_price = ?, category_id = ?, is_active = ?
                    WHERE id = ?
                ");
                $stmt->execute([$name, $description, $unitPrice, $categoryId, $isActive, $serviceId]);
                
                sendJsonResponse(['success' => true, 'message' => 'Service updated successfully']);

            } elseif ($action === 'delete') {
                $serviceId = intval($_POST['service_id'] ?? 0);
                
                if (!$serviceId) {
                    sendJsonResponse(['success' => false, 'message' => 'Service ID required'], 400);
                }

                $stmt = $db->prepare("DELETE FROM services WHERE id = ?");
                $stmt->execute([$serviceId]);
                
                sendJsonResponse(['success' => true, 'message' => 'Service deleted successfully']);
            }
            break;

        default:
            sendJsonResponse(['success' => false, 'message' => 'Method not allowed'], 405);
    }
} catch (Exception $e) {
    logError("Services API error: " . $e->getMessage());
    sendJsonResponse(['success' => false, 'message' => 'Internal server error'], 500);
}
?>