<?php
require_once '../config/config.php';
require_once '../config/database.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

$auth->requireAdmin();

// Get parameters
$dateRange = $_GET['range'] ?? 'today';
$startDate = $_GET['start_date'] ?? date('Y-m-d');
$endDate = $_GET['end_date'] ?? date('Y-m-d');

// Calculate actual date range
switch ($dateRange) {
    case 'today':
        $start = date('Y-m-d 00:00:00');
        $end = date('Y-m-d 23:59:59');
        break;
    case 'yesterday':
        $start = date('Y-m-d 00:00:00', strtotime('-1 day'));
        $end = date('Y-m-d 23:59:59', strtotime('-1 day'));
        break;
    case 'week':
        $start = date('Y-m-d 00:00:00', strtotime('monday this week'));
        $end = date('Y-m-d 23:59:59', strtotime('sunday this week'));
        break;
    case 'month':
        $start = date('Y-m-01 00:00:00');
        $end = date('Y-m-t 23:59:59');
        break;
    case 'custom':
        $start = $startDate . ' 00:00:00';
        $end = $endDate . ' 23:59:59';
        break;
    default:
        $start = date('Y-m-d 00:00:00');
        $end = date('Y-m-d 23:59:59');
}

try {
    // Get sales data
    $stmt = $db->prepare("
        SELECT 
            s.receipt_number,
            s.created_at,
            s.customer_name,
            u.full_name as cashier_name,
            s.payment_method,
            s.total_amount
        FROM sales s
        JOIN users u ON s.cashier_id = u.id
        WHERE s.created_at BETWEEN ? AND ?
        ORDER BY s.created_at DESC
    ");
    $stmt->execute([$start, $end]);
    $sales = $stmt->fetchAll();

    // Set headers for CSV download
    $filename = 'sales-report-' . date('Y-m-d') . '.csv';
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="' . $filename . '"');

    // Create CSV content
    $output = fopen('php://output', 'w');

    // Add headers
    fputcsv($output, [
        'Receipt Number',
        'Date',
        'Customer',
        'Cashier',
        'Payment Method',
        'Total Amount'
    ]);

    // Add data rows
    foreach ($sales as $sale) {
        fputcsv($output, [
            $sale['receipt_number'],
            formatDate($sale['created_at'], 'Y-m-d H:i'),
            $sale['customer_name'] ?: 'Walk-in',
            $sale['cashier_name'],
            strtoupper($sale['payment_method']),
            $sale['total_amount']
        ]);
    }

    fclose($output);

} catch (Exception $e) {
    logError("Error exporting data: " . $e->getMessage());
    die('Error exporting data');
}
?>