# Cyber Shop POS System - PHP/MySQL

## Installation Guide

### Requirements
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache/Nginx web server
- mod_rewrite enabled

### Installation Steps

1. **Upload Files**
   - Upload all files to your web server directory
   - Ensure proper file permissions (755 for directories, 644 for files)

2. **Database Setup**
   - Create a new MySQL database
   - Import the `database/schema.sql` file
   - Import the `database/sample_data.sql` file for demo data

3. **Configuration**
   - Copy `config/config.example.php` to `config/config.php`
   - Update database credentials in `config/config.php`
   - Set your shop details in the configuration

4. **Default Login Credentials**
   - Admin: admin@cybershop.ke / admin123
   - Cashier: cashier@cybershop.ke / cashier123

### Features

- ✅ Role-based authentication (Admin/Cashier)
- ✅ Service/Product management with categories
- ✅ Fast POS interface with receipt printing
- ✅ Comprehensive sales reporting
- ✅ User management system
- ✅ Configurable shop settings
- ✅ Responsive design for desktop/tablet
- ✅ Secure password hashing
- ✅ Transaction tracking
- ✅ Export functionality (CSV/PDF)

### File Structure

```
php-pos-system/
├── config/
│   ├── config.php
│   └── database.php
├── database/
│   ├── schema.sql
│   └── sample_data.sql
├── includes/
│   ├── auth.php
│   ├── functions.php
│   └── header.php
├── assets/
│   ├── css/
│   ├── js/
│   └── images/
├── pages/
│   ├── dashboard.php
│   ├── pos.php
│   ├── services.php
│   ├── reports.php
│   ├── users.php
│   └── settings.php
├── api/
│   ├── auth.php
│   ├── services.php
│   ├── sales.php
│   └── reports.php
├── receipts/
│   └── generate.php
└── index.php
```

### Security Features

- Password hashing using PHP's password_hash()
- SQL injection prevention with prepared statements
- CSRF protection
- Session management
- Role-based access control

### Support

For technical support or customization requests, please refer to the documentation in each file.