-- Additional inventory table for stock management

CREATE TABLE IF NOT EXISTS `inventory` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service_id` int(11) NOT NULL,
  `stock_quantity` int(11) NOT NULL DEFAULT 0,
  `min_stock_level` int(11) NOT NULL DEFAULT 5,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `service_id` (`service_id`),
  CONSTRAINT `inventory_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert sample inventory data
INSERT INTO `inventory` (`service_id`, `stock_quantity`, `min_stock_level`) VALUES
(16, 50, 10),  -- Flash Disk 8GB
(17, 30, 5),   -- Flash Disk 16GB
(18, 20, 5),   -- Flash Disk 32GB
(19, 100, 20), -- Pen (Blue)
(20, 100, 20), -- Pen (Black)
(21, 10, 2);   -- A4 Paper (Ream)